<?php

namespace App\AppEvents;

use Illuminate\Database\Eloquent\Model;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;
    protected $fillable = array('name', 'description', 'start_date');

    public function venues()
    {
        return $this->belongsToMany('App\AppEvents\Venue')->withPivot('date');
    }

    public function presenters()
    {
        return $this->belongsToMany('App\Presenters\Presenter');
    }

    public function pricings()
    {
        return $this->hasMany('App\AppEvents\Pricing');
    }

    public function tickets()
    {
        return $this->hasMany('App\AppEvents\Ticket');
    }

    public function sections()
    {
        return $this->hasMany('App\AppEvents\Section');
    }

    public function additionals()
    {
        return $this->hasMany('App\AppEvents\Additional');
    }

}